


#include "../../cpc/cpcglob.h"
#include "../../cpc/cpc.h"
//#include "../debugger/breakpt.h"



#include "../z80/z80.h"

int CPU_GetPC(void);

Z80_REGISTERS Z80;

void    Z80_Reti(Z80_REGISTERS *pZ80)
{
    //CPU_Reti();
}



void Z80_AcknowledgeInterrupt(Z80_REGISTERS *pZ80)
{
	Z80_BYTE vec = CPC_AcknowledgeInterrupt();
	Z80_SetInterruptVector(pZ80, vec);
	CPU_SetIntVectorAddress(((CPU_GetReg(CPU_I)&0x0ff)<<8)+(vec&0x0ff));
}


Z80_BYTE Z80_RD_MEM(const Z80_WORD addr)
{
    Z80_BYTE data = CPU_RD_MEM(addr);
	return data;
}

void Z80_WR_MEM(const Z80_WORD addr, const Z80_BYTE val)
{
   CPU_WR_MEM((Z80_WORD)addr, (Z80_BYTE)val);
}


Z80_BYTE Z80_DoIn(const Z80_WORD port)
{

	//CPU_SetIOPort(port);
    Z80_BYTE data = CPU_DoIn((const Z80_WORD)port);
    //CPU_SetIOData(data);

	if (CPC_GetHardware()==CPC_HW_CPCPLUS)
	{
		/* on plus, byte on the bus will be last byte of the instruction used to do the read */
		/* tested and confirmed on 464 Plus, and this result is stable */
		/* doesn't happen on CPC */
		CPU_SetDataBus(CPU_RD_MEM(CPU_GetPC()-1));
	}

	return data;
}



void Z80_DoOut(const Z80_WORD port, const Z80_BYTE val)
{
  //CPU_SetIOData(val);
  //CPU_SetIOPort(port);

  CPU_DoOut((const Z80_WORD)port, (const Z80_BYTE)val);

}






Z80_BYTE		Z80_RD_BYTE_IM0()
{
	// change depending on cpc or cpc+
	return 0x0ff;
}

Z80_WORD		Z80_RD_WORD_IM0()
{
	// change depending on cpc or cpc+
	return 0x0ffff;
}

BOOL CPU_GetINTState(void)
{
    return Z80_GetInterruptRequest(&Z80);
}

void CPU_SetINTState(BOOL bState)
{
     Z80_SetInterruptInput(&Z80, bState);
}

void My_Z80_SetInterruptVector(int vector)
{
	Z80_SetInterruptVector(&Z80, vector);
}

void CPU_Init()
{
  //printf("CPU Init\n");
  Z80_Init(&Z80);
}

void CPU_Reset()
{
    Z80_RestartReset(&Z80);
}

void CPU_Power()
{
	Z80_Init(&Z80);
}

void CPU_PowerOn()
{
    Z80_RestartPower(&Z80);
}

BOOL CPU_GetInterruptRequest()
{
     return Z80_GetInterruptRequest(&Z80);
}

BOOL CPU_GetNMIInput()
{
    return (!Z80_GetNMIInterruptInput(&Z80));
}

void CPU_SetNMIState(BOOL bState)
{
    //comes in false which means high
    //if bState ==true want low
    // bState sets NMI low
	Z80_SetNMIInterruptInput(&Z80, bState);
}


void GetRegisterShiftAndMask(int nReg, int * nShift, int  *nMask)
{
    *nShift = 0;
    *nMask = 0x0ffff;
    switch (nReg)
    {
        case CPU_A:
        {
            *nShift = 8;
            *nMask = 0x0ff;
        }
        return;
    case CPU_B:
        {
            *nShift = 8;
            *nMask = 0x0ff;
        }
        return;
    case CPU_C:
        {
            *nShift = 0;
            *nMask = 0x0ff;
        }
        return;
    case CPU_D:
        {
            *nShift = 8;
            *nMask = 0x0ff;
        }
        return;
    case CPU_E:
        {
            *nShift = 0;
            *nMask = 0x0ff;
        }
        return;
    case CPU_H:
        {
            *nShift = 8;
            *nMask = 0x0ff;
        }
        return;
    case CPU_L:
        {
            *nShift = 0;
            *nMask = 0x0ff;
        }
        return;
    }
}

int CPU_GetPC()
{
    return Z80_GetReg(&Z80, Z80_PC);
}

int CPU_GetSP()
{
    return Z80_GetReg(&Z80, Z80_SP);
}

BOOL CPU_GetFlag(int nCPUFlag)
{
    int nFlag = 0;

    switch (nCPUFlag)
    {
        case CPU_FLAG_SIGN:
            nFlag = Z80_SIGN_FLAG;
            break;

        case CPU_FLAG_ZERO:
            nFlag = Z80_ZERO_FLAG;
            break;

        case CPU_FLAG_BIT5:
            nFlag = Z80_UNUSED_FLAG2;
            break;
    case CPU_FLAG_HALF_CARRY:
            nFlag = Z80_HALFCARRY_FLAG;
            break;
    case CPU_FLAG_BIT3:
            nFlag = Z80_UNUSED_FLAG1;
            break;
    case CPU_FLAG_PARITYOVERFLOW:
            nFlag = Z80_PARITY_FLAG;
            break;
    case CPU_FLAG_ADDSUBTRACT:
            nFlag = Z80_SUBTRACT_FLAG;
            break;
    case CPU_FLAG_CARRY:
            nFlag = Z80_CARRY_FLAG;
            break;

    }
    return ((Z80_GetReg(&Z80,Z80_F)&nFlag)!=0);

}

int CPU_GetReg(int nReg)
{
    int nData = 0x00;
    int nShift, nMask;

    GetRegisterShiftAndMask(nReg, &nShift, &nMask);

    switch (nReg)
    {
    case CPU_A:
        nData = Z80_GetReg(&Z80, Z80_AF);
        break;
    case CPU_B:
        nData = Z80_GetReg(&Z80, Z80_BC);
        break;
    case CPU_C:
        nData = Z80_GetReg(&Z80, Z80_BC);
        break;
    case CPU_D:
        nData = Z80_GetReg(&Z80, Z80_DE);
        break;
    case CPU_E:
        nData = Z80_GetReg(&Z80, Z80_DE);
        break;
    case CPU_H:
        nData = Z80_GetReg(&Z80, Z80_HL);
        break;
    case CPU_L:
        nData = Z80_GetReg(&Z80, Z80_HL);
        break;
   case CPU_HL:
        nData = Z80_GetReg(&Z80, Z80_HL);
        break;
    case CPU_DE:
        nData = Z80_GetReg(&Z80, Z80_DE);
        break;
    case CPU_BC:
        nData = Z80_GetReg(&Z80, Z80_BC);
        break;
    case CPU_AF:
        nData = Z80_GetReg(&Z80, Z80_AF);
        break;
    case CPU_IX:
        nData = Z80_GetReg(&Z80, Z80_IX);
        break;
    case CPU_IY:
        nData = Z80_GetReg(&Z80, Z80_IY);
        break;
    case CPU_I:
        nData = Z80_GetReg(&Z80, Z80_I);
        break;
    case CPU_R:
        nData = Z80_GetReg(&Z80, Z80_R);
        break;
    case CPU_IM:
        nData = Z80_GetReg(&Z80, Z80_IM);
        break;
    case CPU_MEMPTR:
        nData = Z80_GetReg(&Z80, Z80_MEMPTR);
        break;
   case CPU_HL2:
        nData = Z80_GetReg(&Z80, Z80_HL2);
        break;
    case CPU_DE2:
        nData = Z80_GetReg(&Z80, Z80_DE2);
        break;
    case CPU_BC2:
        nData = Z80_GetReg(&Z80, Z80_BC2);
        break;
    case CPU_AF2:
        nData = Z80_GetReg(&Z80, Z80_AF2);
        break;
      case CPU_PC:
        nData = Z80_GetReg(&Z80, Z80_PC);
        break;
    case CPU_SP:
        nData = Z80_GetReg(&Z80, Z80_SP);
        break;
    case CPU_IFF1:
        nData = Z80_GetReg(&Z80, Z80_IFF1);
        break;
    case CPU_IFF2:
        nData = Z80_GetReg(&Z80, Z80_IFF2);
        break;
    }
    return (nData>>nShift) & nMask;
}

void CPU_SetReg(int nReg, int nValue)
{

   int nData = 0x00;
   int nShift, nMask;
   GetRegisterShiftAndMask(nReg, &nShift, &nMask);
   
   switch (nReg)
    {
    case CPU_A:
        nData = Z80_GetReg(&Z80, Z80_AF);
        break;
    case CPU_B:
        nData = Z80_GetReg(&Z80, Z80_BC);
        break;
    case CPU_C:
        nData = Z80_GetReg(&Z80, Z80_BC);
        break;
    case CPU_D:
        nData = Z80_GetReg(&Z80, Z80_DE);
        break;
    case CPU_E:
        nData = Z80_GetReg(&Z80, Z80_DE);
        break;
    case CPU_H:
        nData = Z80_GetReg(&Z80, Z80_HL);
        break;
    case CPU_L:
        nData = Z80_GetReg(&Z80, Z80_HL);
        break;
   case CPU_HL:
        nData = Z80_GetReg(&Z80, Z80_HL);
        break;
    case CPU_DE:
        nData = Z80_GetReg(&Z80, Z80_DE);
        break;
    case CPU_BC:
        nData = Z80_GetReg(&Z80, Z80_BC);
        break;
    case CPU_AF:
        nData = Z80_GetReg(&Z80, Z80_AF);
        break;
    case CPU_IX:
        nData = Z80_GetReg(&Z80, Z80_IX);
        break;
    case CPU_IY:
        nData = Z80_GetReg(&Z80, Z80_IY);
        break;
    case CPU_I:
        nData = Z80_GetReg(&Z80, Z80_I);
        break;
    case CPU_R:
        nData = Z80_GetReg(&Z80, Z80_R);
        break;
    case CPU_IM:
        nData = Z80_GetReg(&Z80, Z80_IM);
        break;
    case CPU_MEMPTR:
        nData = Z80_GetReg(&Z80, Z80_MEMPTR);
        break;
   case CPU_HL2:
        nData = Z80_GetReg(&Z80, Z80_HL2);
        break;
    case CPU_DE2:
        nData = Z80_GetReg(&Z80, Z80_DE2);
        break;
    case CPU_BC2:
        nData = Z80_GetReg(&Z80, Z80_BC2);
        break;
    case CPU_AF2:
        nData = Z80_GetReg(&Z80, Z80_AF2);
        break;
      case CPU_PC:
        nData = Z80_GetReg(&Z80, Z80_PC);
        break;
    case CPU_SP:
        nData = Z80_GetReg(&Z80, Z80_SP);
        break;
    case CPU_IFF1:
        nData = Z80_GetReg(&Z80, Z80_IFF1);
        break;
    case CPU_IFF2:
        nData = Z80_GetReg(&Z80, Z80_IFF2);
        break;
    }
    nData = nData & !nMask;
    nData = nData | ((nValue&nMask)<<nShift);

   switch (nReg)
    {
    case CPU_A:
        Z80_SetReg(&Z80, Z80_AF, nData);
        break;
    case CPU_B:
        Z80_SetReg(&Z80, Z80_BC, nData);
        break;
    case CPU_C:
        Z80_SetReg(&Z80, Z80_BC, nData);
        break;
    case CPU_D:
        Z80_SetReg(&Z80, Z80_DE, nData);
        break;
    case CPU_E:
        Z80_SetReg(&Z80, Z80_DE, nData);
        break;
    case CPU_H:
        Z80_SetReg(&Z80, Z80_HL, nData);
        break;
    case CPU_L:
        Z80_SetReg(&Z80, Z80_HL, nData);
        break;
   case CPU_HL:
        Z80_SetReg(&Z80, Z80_HL, nData);
        break;
    case CPU_DE:
        Z80_SetReg(&Z80, Z80_DE, nData);
        break;
    case CPU_BC:
        Z80_SetReg(&Z80, Z80_BC, nData);
        break;
    case CPU_AF:
        Z80_SetReg(&Z80, Z80_AF, nData);
        break;
    case CPU_IX:
        Z80_SetReg(&Z80, Z80_IX, nData);
        break;
    case CPU_IY:
        Z80_SetReg(&Z80, Z80_IY, nData);
        break;
    case CPU_I:
        Z80_SetReg(&Z80, Z80_I, nData);
        break;
    case CPU_R:
        Z80_SetReg(&Z80, Z80_R, nData);
        break;
    case CPU_MEMPTR:
        Z80_SetReg(&Z80, Z80_MEMPTR, nData);
        break;
   case CPU_HL2:
        Z80_SetReg(&Z80, Z80_HL2, nData);
        break;
    case CPU_DE2:
        Z80_SetReg(&Z80, Z80_DE2, nData);
        break;
    case CPU_BC2:
        Z80_SetReg(&Z80, Z80_BC2, nData);
        break;
    case CPU_AF2:
        Z80_SetReg(&Z80, Z80_AF2, nData);
        break;
    case CPU_PC:
        Z80_SetReg(&Z80, Z80_PC, nData);
        break;
    case CPU_SP:
        Z80_SetReg(&Z80, Z80_SP, nData);
        break;
   case CPU_IFF1:
        Z80_SetReg(&Z80, Z80_IFF1, nData);
        break;
    case CPU_IFF2:
        Z80_SetReg(&Z80, Z80_IFF2, nData);
        break;
	case CPU_IM:
	    Z80_SetReg(&Z80, Z80_IM, nData);
        break;
    }
}

int CPU_ExecuteCycles()
{
  return Z80_Execute(&Z80);
}
